unit IEThread;

interface

uses
  Classes, StdCtrls, IECommThread, InferenceEngine;

type
  TIEThread = class(TThread)
  { Purpose: To run an inference engine in a separate thread.  Note that for
    I/O communication, you have to be VERY careful.  Synchronizing to use
    the VCL objects' methods and properties MAY not work if the main thread
    tries to use TInferenceEngine.Lock.  A deadlock occurs where the main thread
    is blocked waiting for the thread to unlock the inference engine and this thread
    is blocked waiting to synchronize with the main application thread.  See
    the TIECommunicationThread for an example of how to send output }
  private
    { Private declarations }
    FIE: TInferenceEngine;
    FCommThread: TIECommThread;
  protected
    procedure Execute; override;
    procedure InferenceEnginePrintOut(Sender: TObject; OutID,
      Text: String);
    property CommThread: TIECommThread read FCommThread;
  public
    constructor Create( IE: TInferenceEngine; ListBox: TListBox ); virtual;
    destructor Destroy; override;
    property IE: TInferenceEngine read FIE;
  end;

implementation

{ TIEThread }

constructor TIEThread.Create(IE: TInferenceEngine; ListBox: TListBox);
begin
     // Create thread suspended
     inherited Create( True );
     Priority := tpLower;
     // create the communications thread
     FCommThread := TIECommThread.Create( ListBox );
     FCommThread.FreeOnTerminate := True;
     // IE is the inference engine to run
     FIE := IE;
     IE.OnPrintOut := InferenceEnginePrintOut;
end;

destructor TIEThread.Destroy;
begin
     CommThread.Terminate;
     inherited;
end;

procedure TIEThread.Execute;
begin
     while (not Terminated) do
           IE.Run;
end;

procedure TIEThread.InferenceEnginePrintOut(Sender: TObject; OutID,
  Text: String);
begin
     // pass the message to the communication thread
     CommThread.Push( Text );
end;

end.
