unit ThreadMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StringPackage, StandardPackage, PredicatePackage, ObjectPackage,
  MiscPackage, IEPackages, MathPackage, InferenceEngine, StdCtrls,
  IEThread, ExtCtrls;

type
  TForm1 = class(TForm)
    InferenceEngine1: TInferenceEngine;
    InferenceEngine2: TInferenceEngine;
    MathPackage1: TMathPackage;
    MiscPackage1: TMiscPackage;
    PredicatePackage1: TPredicatePackage;
    StandardPackage1: TStandardPackage;
    StringPackage1: TStringPackage;
    ListBox1: TListBox;
    ListBox2: TListBox;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    Splitter1: TSplitter;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Thread1: TIEThread;
    Thread2: TIEThread;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
     // Add the packages we need to both inference engines,
     // sharing resources and saving memory.  Note, in a real application
     // you would NOT want TPrintOutFunction and TReadXXXFunction to share
     // since they access one variable.  We are only going to run non-input
     // expert systems so we will be ok
     StandardPackage1.Reasoners.Add( InferenceEngine1 );
     StandardPackage1.Reasoners.Add( InferenceEngine2 );
     MathPackage1.Reasoners.Add( InferenceEngine1 );
     MathPackage1.Reasoners.Add( InferenceEngine2 );
     PredicatePackage1.Reasoners.Add( InferenceEngine1 );
     PredicatePackage1.Reasoners.Add( InferenceEngine2 );
     StringPackage1.Reasoners.Add( InferenceEngine1 );
     StringPackage1.Reasoners.Add( InferenceEngine2 );
     MiscPackage1.Reasoners.Add( InferenceEngine1 );
     MiscPackage1.Reasoners.Add( InferenceEngine2 );
     // Create a thread for each inference engine
     Thread1 := TIEThread.Create( InferenceEngine1, ListBox1 );
     Thread2 := TIEThread.Create( InferenceEngine2, ListBox2 );
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     Thread1.Terminate;
     Thread2.Terminate;
     // wait for a couple seconds so that the threads can terminate,
     // with a real application, you would probably want to wait on 2 variables
     // that would be set in the thread's OnTerminate event
     Sleep(2000);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
     ListBox1.Items.Clear;
     ListBox2.Items.Clear;
     // Lock Inference Engine1 and add the .IE file
     with InferenceEngine1 do
     begin
          // Lock the InferenceEngine so that we can modify it without stomping
          // on the other thread
          Lock;
          try
             // Tell the engine to stop when we wake it back up
             Halt := True;
             // Clear the rules, facts, and everything else
             Clear;
             LoadFromFile( 'fullmab.ie' );
             // reset the engine to prepare for inference
             Reset;
          finally
             Unlock;
          end;
     end;
     // Lock Inference Engine2 and add the .IE file
     with InferenceEngine2 do
     begin
          // Lock the InferenceEngine so that we can modify it without stomping
          // on the other thread
          Lock;
          try
             // Tell the engine to stop when we wake it back up
             Halt := True;
             // Clear the rules, facts, and everything else
             Clear;
             LoadFromFile( 'wordgame.ie' );
             // reset the engine to prepare for inference
             Reset;
          finally
             Unlock;
          end;
     end;
     if Thread1.Suspended then Thread1.Resume;
     if Thread2.Suspended then Thread2.Resume;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
     ShowMessage( 'This message shows that the main thread is free while '+
                  'the other threads are executing in the background' );
end;

end.
